//
//  DetailViewController.m
//  PIT
//
//  Created by VA DEVELOPER on 11/24/12.
//  Copyright (c) 2012 . All rights reserved.
//

#import "DetailViewController.h"
#import "PITItem.h"
//#import "PITImageStore.h"
#import "MapPoint.h"

@implementation DetailViewController
@synthesize item, nameCell, footerCell, ageCell, genderCell, chronicCell, locationCell, mapCell;

NSString * const PITLocationCurrentFreePrefKey = @"";
NSString * const PITLocationCurrentCityPrefKey = @"";
NSString * const PITLocationCurrentStatePrefKey = @"";


- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    NSLog(@"DetailViewController: Init");
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if(self) {
        [[NSNotificationCenter defaultCenter] addObserver:self
        selector:@selector(didEnterBackground:) name:@"didEnterBackground"
        object:nil];
        
        [[NSNotificationCenter defaultCenter] addObserver:self
        selector:@selector(didBecomeActive:) name:@"didBecomeActive"
        object:nil];
    }
    return self;
}



- (void) viewDidLoad {
    NSLog(@"DetailViewController: View Loaded");    
    [super viewDidLoad];
    [worldView setShowsUserLocation:YES];

    
    UITapGestureRecognizer *gestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(hideKeyboard)];
    [self.view addGestureRecognizer:gestureRecognizer];
    gestureRecognizer.cancelsTouchesInView = NO;
    
    [[self view] setBackgroundColor:[UIColor groupTableViewBackgroundColor]];
    
}



- (void) viewWillAppear:(BOOL)animated {
    NSLog(@"DetailViewController: View Appeared");
    
    [super viewWillAppear:animated];
    [activityIndicator startAnimating];
    
    NSLog(@"DetailViewController: Loading stored record");
    
    [fieldFirstName setText:[item itemFirstName]];
    [fieldMiddleName setText:[item itemMiddleName]];
    [fieldLastName setText:[item itemLastName]];
    
    if ([item itemAge]) {
        [fieldAge setText: [NSString stringWithFormat:@"%d", [item itemAge]]];
    } else {
        [fieldAge setText:@""];
    }
    
    int currentGenderValue = ([[item itemGender] isEqualToString:@"M"]) ? 0 : 1;
    [controlGender setSelectedSegmentIndex: currentGenderValue];
    
    int currentChronicValue = ([item itemChronic]) ? 0 : 1;
    [controlChronic setSelectedSegmentIndex: currentChronicValue];
    
    [fieldFreeLocation setText:[item itemFreeLocation]];
    [fieldCity setText:[item itemCity]];
    [fieldState setText:[item itemState]];
    
    if ([item itemLatitude] > 0 && [item itemLongitude] > 0 && [item itemAccuracy] <= 100) {
        dblCurrentLocationLat = [item itemLatitude];
        dblCurrentLocationLon = [item itemLongitude];
        dblCurrentLocationAcc = [item itemAccuracy];
        
        NSLog(@"DetailViewController: Using Stored Location (%f, %f, %f).",dblCurrentLocationLat,dblCurrentLocationLon,dblCurrentLocationAcc);
    }
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateStyle:NSDateFormatterMediumStyle];
    [dateFormatter setTimeStyle:NSDateFormatterNoStyle];
    
    [dateLabel setText:[dateFormatter stringFromDate:[item dateCreated]]];
    
    // No pictures, please
    //[imageView setImage:nil];
    /*
    NSString *imageKey = [item imageKey];
    
    if (imageKey) {
        UIImage *imageToDisplay = [[PITImageStore sharedStore] imageForKey:imageKey];
        [imageView setImage:imageToDisplay];
    } else {
        [imageView setImage:nil];
    }
     */
    
    
    
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (indexPath.row == 0) return nameCell;
    if (indexPath.row == 1) return ageCell;
    if (indexPath.row == 2) return genderCell;
    if (indexPath.row == 3) return chronicCell;
    if (indexPath.row == 4) return locationCell;
    if (indexPath.row == 5) return mapCell;
    if (indexPath.row == 6) return footerCell;
    
    return nil;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Sized taken from XIB
    if (indexPath.row == 0) return 114; // Name
    if (indexPath.row == 1) return 49; // Age
    if (indexPath.row == 2) return 64; // Gender
    if (indexPath.row == 3) return 91; // Chronic
    if (indexPath.row == 4) return 102; // Location
    if (indexPath.row == 5) return 128; // Map
    if (indexPath.row == 6) return 300; // Footer
    return 30;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 7;
}

- (void) viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    [[self view] endEditing:YES];
    
    NSLog(@"DetailViewController: View Disappeared");
    
    
    BOOL saveFlag = FALSE;
    
    if (saveFlag == FALSE && [[fieldFirstName text] length] > 0) saveFlag = TRUE;
    if (saveFlag == FALSE && [[fieldMiddleName text] length] > 0) saveFlag = TRUE;
    if (saveFlag == FALSE && [[fieldLastName text] length] > 0) saveFlag = TRUE;
    if (saveFlag == FALSE && [[fieldAge text] length] > 0) saveFlag = TRUE;
    if (saveFlag == FALSE && [[fieldFreeLocation text] length] > 0) saveFlag = TRUE;
//   if (saveFlag == FALSE && [[fieldCity text] length] > 0) saveFlag = TRUE;
//    if (saveFlag == FALSE && [[fieldState text] length] > 0) saveFlag = TRUE;
    
    if (saveFlag) {
        // Gender is set automatically in PITItem, and adjusted via segment
        // Chronic is set automatically in PITItem, and adjusted via segment
        
        [item setItemFirstName:[fieldFirstName text]];
        [item setItemMiddleName:[fieldMiddleName text]];
        [item setItemLastName:[fieldLastName text]];
        
        [item setItemAge:[[fieldAge text] intValue]];
        
        NSLog(@"DetailViewController: Variables Lat: %f Lon: %f Acc: %f", dblCurrentLocationLat, dblCurrentLocationLon, dblCurrentLocationAcc);
        NSLog(@"DetailViewController: Data Object Lat: %f Lon: %f Acc: %f", [item itemLatitude], [item itemLongitude], [item itemAccuracy]);
        
        if ([item itemLatitude] == 0 &&
               [item itemLongitude] == 0 &&
               [item itemAccuracy] == 0 &&
               [[item itemFreeLocation] length] > 0 &&
                [[item itemCity] length] > 0 &&
                [[item itemState] length] > 0) {
            NSLog(@"Not Storing Coordinates because this appears to be an existing record with no coordinates.");
        } else if ([item itemLatitude] > 0 &&
            [item itemLongitude] < 0 &&
            [item itemAccuracy] <= 100) {
            NSLog(@"Not Storing Coordinates because this was an existing record.");
        } else {
            // Only set if not previously set.
            [item setItemLatitude: dblCurrentLocationLat];
            [item setItemLongitude: dblCurrentLocationLon];
            [item setItemAccuracy: dblCurrentLocationAcc];
            NSLog(@"Preserving Coordinates. (%f, %f, %f)", [item itemLatitude],[item itemLongitude],[item itemAccuracy]);
        }
        
        [item setItemFreeLocation:[fieldFreeLocation text]];
        [item setItemCity:[fieldCity text]];
        [item setItemState:[fieldState text]];
        
        NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
        [defaults setObject:[item itemFreeLocation] forKey:@"PITLocationCurrentFreePrefKey"];
        [defaults setObject:[item itemCity] forKey:@"PITLocationCurrentCityPrefKey"];
        [defaults setObject:[item itemState] forKey:@"PITLocationCurrentStatePrefKey"];
        [defaults synchronize];
        
        NSString *sChronic = [item itemChronic] ? @"TRUE" : @"FALSE";
        NSLog(@"DetailViewController: Record Saved in Memory for Location: %@ City: %@ State: %@ (%@, %@) Coord: (%f, %f, %f)",
              [item itemFreeLocation],
              [item itemCity],
              [item itemState],
              [item itemGender],
              sChronic,
              [item itemLatitude],
              [item itemLongitude],
              [item itemAccuracy]
              );
        
        
        NSLog(@"DetailViewController: Default Location is Now: %@ City: %@ State: %@",
              [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentFreePrefKey"],
              [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentCityPrefKey"],
              [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentStatePrefKey"]);
        
        
    } else {
        [item setItemFirstName: @"-- Incomplete!"];
    }
}

- (void)didEnterBackground:(NSNotification *)notification
{
    NSLog(@"Oh Snap! User went home! (DVC)");
    //self.cityField.hidden = YES;
    //self.colorField.hidden = YES;
    
    //imageView.hidden = YES;
    fieldFirstName.hidden = YES;
    fieldMiddleName.hidden = YES;
    fieldLastName.hidden = YES;
    fieldAge.hidden = YES;
    controlGender.hidden = YES;
    controlChronic.hidden = YES;
    fieldFreeLocation.hidden = YES;
    fieldCity.hidden = YES;
    fieldState.hidden = YES;
    worldView.hidden = YES;
    
}

- (void)didBecomeActive:(NSNotification *)notification
{
    NSLog(@"Oh Snap! User came back! (DVC)");    
    //self.cityField.hidden = NO;
    //self.colorField.hidden = NO;
    
    //imageView.hidden = NO;
    fieldFirstName.hidden = NO;
    fieldMiddleName.hidden = NO;
    fieldLastName.hidden = NO;
    fieldAge.hidden = NO;
    controlGender.hidden = NO;
    controlChronic.hidden = NO;
    fieldFreeLocation.hidden = NO;
    fieldCity.hidden = NO;
    fieldState.hidden = NO;
    worldView.hidden = NO;
}

- (IBAction) saveAndClose:(id)sender {
    [self.navigationController popViewControllerAnimated:YES];
     NSLog(@"DetailViewController: Save and Close");
}

- (void) setItem: (PITItem *) i {
    item = i;
    //[[self navigationItem] setTitle:[item itemTitle]];
    [[self navigationItem] setTitle:@"Veteran Record"];
}

- (IBAction) changeGender:(id) sender {
    switch ([sender selectedSegmentIndex]) {
        case 0: {
            [item setItemGender: @"M"];
        } break;
        case 1: {
            [item setItemGender: @"F"];
        } break;
    }
        
    NSLog(@"DetailViewController: Set GENDER to %@", [item itemGender]);
}

- (IBAction) changeChronic:(id) sender {
    switch ([sender selectedSegmentIndex]) {
        case 0: {
            [item setItemChronic: TRUE];
        } break;
        case 1: {
            [item setItemChronic: FALSE];
        } break;
    }
    
    NSLog(@"DetailViewController: Set CHRONIC to %s", [item itemChronic] ? "TRUE" : "FALSE");
}


- (void)locationManager:(CLLocationManager *)manager
       didFailWithError:(NSError *)error
{
    NSLog(@"DetailViewController: Could not find location: %@", error);
    mapMessage.alpha = 1;
}

- (void)mapView:(MKMapView *)mv didUpdateUserLocation:(MKUserLocation *)u
{
    if (u.location != nil) {
        UIImage *imgStored = [UIImage imageNamed:@"LocationStored.png"];
        UIImage *imgNotFound = [UIImage imageNamed:@"LocationNotFound.png"];
        
        CLLocationCoordinate2D loc = [u coordinate];
        MKCoordinateRegion region = MKCoordinateRegionMakeWithDistance(loc, 250, 250);
        [worldView setRegion:region animated:YES];
        
        // Find out if this is an existing record
        // If so, DO NOT UPDATE THE EXISTING VALUE
        // And check accuracy
        // horizontalAccuracy = accuracy within X meters
        
        NSLog(@"DetailViewController: Variables Lat: %f Lon: %f Acc: %f", dblCurrentLocationLat, dblCurrentLocationLon, dblCurrentLocationAcc);
        NSLog(@"DetailViewController: Data Object Lat: %f Lon: %f Acc: %f", [item itemLatitude], [item itemLongitude], [item itemAccuracy]);    
        
        if ([item itemLatitude] > 0.0 &&
                 [item itemLongitude] < 0.0 &&
                 [item itemAccuracy] <= 100.0) {
            NSLog(@"DetailViewController: Keeping Stored Coordinates");
            
            mapMessage.image = imgStored;
            worldView.alpha = 0;
            mapMessage.alpha = 1;
            // If an existing record
            // Don't do anything but plot current recorded location.
        } else if (dblCurrentLocationLat == 0 &&
            dblCurrentLocationLon == 0 &&
            u.location.horizontalAccuracy <= 100) {
            
            NSLog(@"DetailViewController: Storing Coordinates for record");
            dblCurrentLocationLat = loc.latitude;
            dblCurrentLocationLon = loc.longitude;
            dblCurrentLocationAcc = u.location.horizontalAccuracy;
            worldView.alpha = 1;
            mapMessage.alpha = 0;
            
        } else if (dblCurrentLocationLat != 0 &&
                   dblCurrentLocationLon != 0 &&
                   dblCurrentLocationAcc != 0 &&
                   (dblCurrentLocationLat != loc.latitude ||
                   dblCurrentLocationLon != loc.longitude ||
                   dblCurrentLocationAcc != u.location.horizontalAccuracy) &&
                   u.location.horizontalAccuracy <= 100) {
            
            NSLog(@"DetailViewController: Updating Coordinates for record");
            dblCurrentLocationLat = loc.latitude;
            dblCurrentLocationLon = loc.longitude;
            dblCurrentLocationAcc = u.location.horizontalAccuracy;
            worldView.alpha = 1;
            mapMessage.alpha = 0;
            
        } else {
            NSLog(@"DetailViewController: Cannot get accurate location.");
            // Put up a question mark
            mapMessage.image = imgNotFound;
            mapMessage.alpha = 1;
            worldView.alpha = 1;
        }
        
        NSLog(@"DetailViewController: mapView: Updating MapView Location - Lat: %f Lon: %f Acc: %f", loc.latitude, loc.longitude, u.location.horizontalAccuracy);
        
        [activityIndicator stopAnimating];
    } else {
        NSLog(@"Location NOT Ready! Waiting.");
    }
}


/*
- (IBAction)takePicture:(id)sender {
    UIImagePickerController *imagePicker =
    [[UIImagePickerController alloc]init];
    
    if ([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]){
        [imagePicker setSourceType:UIImagePickerControllerSourceTypeCamera];
    } else {
        [imagePicker setSourceType:UIImagePickerControllerSourceTypePhotoLibrary];
    }
    
    [imagePicker setDelegate:self];
    
    [self presentViewController:imagePicker animated:YES completion:nil];
    
}

- (void) imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary *)info {
    
    NSString *oldKey = [item imageKey];
    
    if (oldKey) {
        
        [[PITImageStore sharedStore] deleteImageForKey:oldKey];
    }
    
    UIImage *image = [info objectForKey:UIImagePickerControllerOriginalImage];
    
    CFUUIDRef newUniqueID = CFUUIDCreate(kCFAllocatorDefault);
    
    CFStringRef newUniqueIDString = CFUUIDCreateString(kCFAllocatorDefault, newUniqueID);
    
    NSString *key = (__bridge NSString *) newUniqueIDString;
    [item setImageKey:key];
    
    [[PITImageStore sharedStore] setImage:image forKey:[item imageKey]];
    
    CFRelease(newUniqueIDString);
    CFRelease(newUniqueID);
    
    [imageView setImage:image];
    [self dismissViewControllerAnimated:YES completion:nil];
}
 */


- (BOOL) textFieldShouldReturn: (UITextField *) textField {
    NSLog(@"DetailViewController: textFieldShouldReturn: resignFirstResponder");
    [textField resignFirstResponder];
    return YES;
}

- (IBAction)backgroundTapped:(id)sender {
    NSLog(@"DetailViewController: backgroundTapped: endEditing");
    [[self view] endEditing:YES];
    
}

- (void) hideKeyboard {
    NSLog(@"DetailViewController: hideKeyboard: endEditing");
    [[self view] endEditing:YES];
}

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
    if (textField == fieldState) {
        NSUInteger curLen = [textField.text length] + [string length] - range.length;
        if (curLen > 2) return FALSE;
    }
    return TRUE;
}


- (void)dealloc
{
    // Tell the location manager to stop sending us messages
    [locationManager setDelegate:nil];
}


@end
